/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.builder;

import com.ldtteam.structurize.placement.StructurePlacer;
import com.ldtteam.structurize.util.BlockUtils;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.modules.ISettingsModule;
import com.minecolonies.api.colony.workorders.IWorkOrder;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.buildings.modules.BuildingResourcesModule;
import com.minecolonies.coremod.colony.buildings.utils.BuilderBucket;
import com.minecolonies.coremod.colony.buildings.utils.BuildingBuilderResource;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingBuilder;
import com.minecolonies.coremod.colony.jobs.JobBuilder;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuild;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildBuilding;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildDecoration;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildRemoval;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIStructureWithWorkOrder;
import com.minecolonies.coremod.entity.ai.util.BuildingStructureHandler;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class EntityAIStructureBuilder
extends AbstractEntityAIStructureWithWorkOrder<JobBuilder, BuildingBuilder> {
    private static final int DEPTH_LEVEL_0 = 60;
    private static final int DEPTH_LEVEL_1 = 30;
    private static final int DEPTH_LEVEL_2 = 15;
    private static final double SPEED_BUFF_0 = 0.5;
    private static final int SPEED_BUFF_1 = 2;
    private static final int SPEED_BUFF_2 = 4;
    private static final int ACTIONS_UNTIL_DUMP = 4096;
    private static final int LEVEL_TO_PURGE_MOBS = 4;
    private int pickUpCount = 0;

    public EntityAIStructureBuilder(@NotNull JobBuilder job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.IDLE, AIWorkerState.START_WORKING, 100), new AITarget(AIWorkerState.START_WORKING, this::checkForWorkOrder, this::startWorkingAtOwnBuilding, 100), new AITarget((IAIState)AIWorkerState.PICK_UP, this::pickUpMaterial, 5));
        this.worker.func_98053_h(true);
    }

    @Override
    public IAIState getStateAfterPickUp() {
        return AIWorkerState.PICK_UP;
    }

    @Override
    public int getBreakSpeedLevel() {
        return this.getSecondarySkillLevel();
    }

    @Override
    public int getPlaceSpeedLevel() {
        return this.getPrimarySkillLevel();
    }

    public IAIState pickUpMaterial() {
        if (this.structurePlacer == null || !((BuildingStructureHandler)((Object)this.structurePlacer.getB())).hasBluePrint()) {
            return AIWorkerState.IDLE;
        }
        if (((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getStage() == null || ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getStage() == BuildingStructureHandler.Stage.CLEAR) {
            this.pickUpCount = 0;
            return AIWorkerState.START_WORKING;
        }
        BuildingBuilder building = (BuildingBuilder)this.getOwnBuilding();
        ArrayList<Tuple<Predicate<ItemStack>, Integer>> neededItemsList = new ArrayList<Tuple<Predicate<ItemStack>, Integer>>();
        BuilderBucket neededRessourcesMap = building.getRequiredResources();
        BuildingResourcesModule module = ((BuildingBuilder)this.getOwnBuilding()).getFirstModuleOccurance(BuildingResourcesModule.class);
        if (neededRessourcesMap != null) {
            for (Map.Entry<String, Integer> entry : neededRessourcesMap.getResourceMap().entrySet()) {
                BuildingBuilderResource res = module.getResourceFromIdentifier(entry.getKey());
                if (res == null) continue;
                int amount = entry.getValue();
                neededItemsList.add(new Tuple<Predicate<ItemStack>, Integer>(itemstack -> ItemStackUtils.compareItemStacksIgnoreStackSize(res.getItemStack(), itemstack, true, true), amount));
            }
        }
        if (neededItemsList.size() <= this.pickUpCount || InventoryUtils.openSlotCount((IItemHandler)this.worker.getInventoryCitizen()) <= 5L) {
            ((BuildingBuilder)this.getOwnBuilding()).checkOrRequestBucket(((BuildingBuilder)this.getOwnBuilding()).getRequiredResources(), this.worker.getCitizenData(), true);
            ((BuildingBuilder)this.getOwnBuilding()).checkOrRequestBucket(((BuildingBuilder)this.getOwnBuilding()).getNextBucket(), this.worker.getCitizenData(), false);
            this.pickUpCount = 0;
            return AIWorkerState.START_WORKING;
        }
        this.needsCurrently = (Tuple)neededItemsList.get(this.pickUpCount);
        ++this.pickUpCount;
        if (InventoryUtils.hasItemInProvider((ICapabilityProvider)building.getTileEntity(), (Predicate)this.needsCurrently.getA())) {
            return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
        }
        return this.pickUpMaterial();
    }

    @Override
    public Class<BuildingBuilder> getExpectedBuildingClass() {
        return BuildingBuilder.class;
    }

    private boolean checkForWorkOrder() {
        if (!((JobBuilder)this.job).hasWorkOrder()) {
            ((BuildingBuilder)this.getOwnBuilding()).searchWorkOrder();
            ((BuildingBuilder)this.getOwnBuilding()).setProgressPos(null, BuildingStructureHandler.Stage.CLEAR);
            return false;
        }
        WorkOrderBuildDecoration wo = ((JobBuilder)this.job).getWorkOrder();
        if (wo == null) {
            ((JobBuilder)this.job).setWorkOrder(null);
            ((BuildingBuilder)this.getOwnBuilding()).setProgressPos(null, null);
            return false;
        }
        IBuilding building = ((JobBuilder)this.job).getColony().getBuildingManager().getBuilding(wo.getSchematicLocation());
        if (building == null && wo instanceof WorkOrderBuild && !(wo instanceof WorkOrderBuildRemoval)) {
            ((JobBuilder)this.job).complete();
            return false;
        }
        return true;
    }

    @Override
    public void setStructurePlacer(BuildingStructureHandler<JobBuilder, BuildingBuilder> structure) {
        if (((JobBuilder)this.job).getWorkOrder().getIteratorType().isEmpty() && ((BuildingBuilder)this.getOwnBuilding()).hasModule(ISettingsModule.class) && ((BuildingBuilder)this.getOwnBuilding()).getSetting(BuildingBuilder.BUILDING_MODE) != null) {
            ((JobBuilder)this.job).getWorkOrder().setIteratorType(((BuildingBuilder)this.getOwnBuilding()).getSetting(BuildingBuilder.BUILDING_MODE).getValue());
        }
        this.structurePlacer = new Tuple<StructurePlacer, BuildingStructureHandler<JobBuilder, BuildingBuilder>>(new StructurePlacer(structure, ((JobBuilder)this.job).getWorkOrder().getIteratorType()), structure);
    }

    @Override
    public boolean isAfterDumpPickupAllowed() {
        return !this.checkForWorkOrder();
    }

    private IAIState startWorkingAtOwnBuilding() {
        if (this.walkToBuilding()) {
            return this.getState();
        }
        return AIWorkerState.LOAD_STRUCTURE;
    }

    private void killMobs() {
        if (((BuildingBuilder)this.getOwnBuilding()).getBuildingLevel() >= 4 && ((JobBuilder)this.job).getWorkOrder() instanceof WorkOrderBuildBuilding) {
            BlockPos buildingPos = ((JobBuilder)this.job).getWorkOrder().getSchematicLocation();
            IBuilding building = this.worker.getCitizenColonyHandler().getColony().getBuildingManager().getBuilding(buildingPos);
            if (building != null) {
                WorldUtil.getEntitiesWithinBuilding(this.world, MonsterEntity.class, building, null).forEach(Entity::func_70106_y);
            }
        }
    }

    @Override
    public void checkForExtraBuildingActions() {
        if (!((BuildingBuilder)this.getOwnBuilding()).hasPurgedMobsToday()) {
            this.killMobs();
            ((BuildingBuilder)this.getOwnBuilding()).setPurgedMobsToday(true);
        }
    }

    @Override
    public IAIState afterRequestPickUp() {
        return AIWorkerState.INVENTORY_FULL;
    }

    @Override
    public IAIState afterDump() {
        return AIWorkerState.PICK_UP;
    }

    @Override
    public boolean walkToConstructionSite(BlockPos currentBlock) {
        if (this.workFrom == null) {
            this.workFrom = this.findRandomPositionToWalkTo(5, currentBlock);
            if (this.workFrom == null && this.pathBackupFactor > 10) {
                this.workFrom = this.worker.func_233580_cy_();
            }
            return false;
        }
        if (this.walkToBlock(this.workFrom)) {
            return false;
        }
        if (BlockPosUtil.getDistance2D(this.worker.func_233580_cy_(), currentBlock) > (long)(5 + 5 * this.pathBackupFactor)) {
            this.workFrom = null;
            return false;
        }
        if (this.pathBackupFactor > 1) {
            --this.pathBackupFactor;
        }
        return true;
    }

    @Override
    public boolean shallReplaceSolidSubstitutionBlock(Block worldBlock, BlockState worldMetadata) {
        return false;
    }

    @Override
    public BlockState getSolidSubstitution(@NotNull BlockPos location) {
        return BlockUtils.getSubstitutionBlockAtWorld((World)this.world, (BlockPos)location).getBlockState();
    }

    @Override
    public int getBlockMiningDelay(@NotNull BlockState state, @NotNull BlockPos pos) {
        int initialDelay = super.getBlockMiningDelay(state, pos);
        if (pos.func_177956_o() > 60 || !((Boolean)MineColonies.getConfig().getServer().restrictBuilderUnderground.get()).booleanValue()) {
            return (int)((double)initialDelay * 0.5);
        }
        if (pos.func_177956_o() > 30) {
            return initialDelay;
        }
        if (pos.func_177956_o() < 15) {
            return initialDelay * 4;
        }
        return initialDelay * 2;
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 4096;
    }

    @Override
    protected void sendCompletionMessage(WorkOrderBuildDecoration wo) {
        super.sendCompletionMessage(wo);
        BlockPos position = wo.getSchematicLocation();
        if (((BuildingBuilder)this.getOwnBuilding()).getManualMode()) {
            boolean hasInQueue = false;
            for (IWorkOrder workorder : ((BuildingBuilder)this.getOwnBuilding()).getColony().getWorkManager().getWorkOrders().values()) {
                if (workorder.getID() == wo.getID() || !workorder.isClaimedBy(this.worker.getCitizenData())) continue;
                hasInQueue = true;
            }
            if (!hasInQueue) {
                if (wo instanceof WorkOrderBuildBuilding) {
                    this.worker.getCitizenChatHandler().sendLocalizedChat("entity.builder.messagebuildcomplete_manual", wo.getDisplayName(), position.func_177958_n(), position.func_177956_o(), position.func_177952_p());
                } else {
                    this.worker.getCitizenChatHandler().sendLocalizedChat("entity.builder.messagedecocomplete_manual", wo.getDisplayName(), position.func_177958_n(), position.func_177956_o(), position.func_177952_p());
                }
                return;
            }
        }
        if (wo instanceof WorkOrderBuildBuilding) {
            this.worker.getCitizenChatHandler().sendLocalizedChat("entity.builder.messagebuildcomplete", wo.getDisplayName(), position.func_177958_n(), position.func_177956_o(), position.func_177952_p());
        } else {
            this.worker.getCitizenChatHandler().sendLocalizedChat("entity.builder.messagedecocomplete", wo.getDisplayName(), position.func_177958_n(), position.func_177956_o(), position.func_177952_p());
        }
    }
}

